
Class Pad

	Public
	
	Method New (x:Float, y:Float, z:Float, size:Float = 8.0, gemcolor:Color = Null)
	
		Local box:Boxf = New Boxf (-size * 0.5, -1.0, -size * 0.5, size * 0.5, 1.0, size * 0.5)
		
		model = Model.CreateBox (box, 2, 2, 2, New PbrMaterial (Color.Grey))
		Cast <PbrMaterial> (model.Material).MetalnessFactor = 1.0
		
		model.Move (x, y, z)
		
		collider = model.AddComponent <BoxCollider> ()
		collider.Box = box

		body = model.AddComponent <RigidBody> ()
		body.Mass = 0.0

		body.CollisionMask	= COLL_PAD
		body.CollisionGroup	= PAD_COLLIDES_WITH
		
		' TODO: Move to Level class...
		
		If gemcolor <> Null
			Local sg:SpaceGem = New SpaceGem (x, y, z, size * 0.5, gemcolor)
'			Game.SpaceGemCount = Game.SpaceGemCount + 1
'			Game.CurrentLevel.SpaceGemAdded ()
		Endif
		
	End

	Private

	Field model:Model				' mojo3d Model
	Field collider:BoxCollider		' Bullet physics collider
	Field body:RigidBody			' Bullet physics body
	
End
